// #name = ChainZoom+
// #version = 2.0
// #date = 2002-04-30
// #author =J1GenX original code by Runar
// #email = J1GenX@chicki.de or runar@vsdn.org
// #web =http://www.chicki.de http://www.vsdn.org
// #description = ChainZoom function + Shrikezoom function
// #status = Release 3

// exec("scripts/autoexec/chainzoom.cs");

// Set default prefs if they aren't set.
if(!$pref::Zoom::Default)
{
	// Get the default sensitivity values
	$pref::Zoom::NormSensX = moveMap.getScale(mouse, xaxis);
	$pref::Zoom::NormSensY = moveMap.getScale(mouse, yaxis);

	// Sensitivity-factor to change to when zooming
	$pref::Zoom::SensFactor = 0.75;

	// Do we want to zoom when we chain?
	$pref::Zoom::ChainZoom = 1;

	// What FOV to use when we chain?
	$pref::Zoom::ChainFOV = 90;

	// Reset to this FOV.
	$pref::Zoom::Default = 120;

	// Shrikefire FOV
	$pref::Zoom::ShrikeFOV = 50;
}
function ZoomSetSens(%x, %y)
{
	%Flags = moveMap.isInverted(mouse, yaxis) ? "SI" : "S";

	moveMap.bind( mouse, xaxis, "S", %x, "yaw" );
	moveMap.bind( mouse, yaxis, %Flags, %y, "pitch" );
}
function ZoomResetFOV()
{
	$pref::Zoom::Current = $pref::Zoom::Default;
	$pref::player::currentFOV = $pref::Zoom::Level[$pref::Zoom::Current];
}
function bomberpstart() {
clientCmdStartBomberSight();
}
function bomberpend() {
clientCmdEndBomberSight();
}
function flying()
{
$flycheck = "true";
}

function walking()
{
$flycheck = "false";
}

function ZoomMouseFire(%val)
{
	if(%val)
	{
		if($CurrentWeapon $= "Chaingun" && $pref::Zoom::ChainZoom)
		{
			if($flycheck $= "true") {
			setFov($pref::Zoom::ShrikeFOV);
}
else {
			ZoomSetSens($pref::Zoom::NormSensX * $pref::Zoom::SensFactor, $pref::Zoom::NormSensY * $pref::Zoom::SensFactor);
			setFov($pref::Zoom::ChainFOV);
}
			$isChainFOV = 1;
		}
	}
	else
	{
		if($isChainFOV)
		{
			ZoomSetSens($pref::Zoom::NormSensX, $pref::Zoom::NormSensY);
			setFov($pref::player::defaultFov);
			$isChainFOV = 0;
		}

	}
}
function ZoomChainZoomToggle(%val)
{
	if(%val)
	{
		$pref::Zoom::ChainZoom = !$pref::Zoom::ChainZoom;

		if($pref::Zoom::ChainZoom)
			clientCmdBottomPrint("ChainZoom is now: On", 2, 1);
		else
			clientCmdBottomPrint("ChainZoom is now: Off", 2, 1);
	}
}

// Package def.
package Zoom
{
	// Need a hook to the fire-function
	function mouseFire(%val)
	{
		parent::mouseFire(%val);

		ZoomMouseFire(%val);
	}
	// Need this to keep track of weapon mounted (excluding sniperrifle..)
	function clientCmdSetWeaponsHudActive(%slot, %ret, %vis)
	{
		Parent::clientCmdSetWeaponsHudActive(%slot, %ret, %vis);

		if(%slot > -1)
		{
				$LastWeapon = $CurrentWeapon;
				$CurrentWeapon = $WeaponNames[%slot];
		}
	}

	// Hook to fix the FOV bug
	function ClientCmdDisplayHuds()
	{
		parent::ClientCmdDisplayHuds();

	        schedule(150, 0, setFov, $pref::player::defaultFov);
		schedule(1000, 0, setFov, $pref::player::defaultFov);
    	}
	// Overrides MouseConfigDlg::onOK
	function MouseConfigDlg::onOK( %this )
	{
		%xSens = MouseXSlider.getValue() * 2;
		%ySens = MouseYSlider.getValue() * 2;
		moveMap.bind( mouse, xaxis, "S", %xSens, "yaw" );
		%yFlags = InvertMouseTgl.getValue() ? "SI" : "S";
		moveMap.bind( mouse, yaxis, %yFlags, %ySens, "pitch" );

		$pref::Zoom::NormSensX = %xSens;
		$pref::Zoom::NormSensY = %ySens;

		Canvas.popDialog( MouseConfigDlg );
	}


	// Adds key-mapping to options
	function OptionsDlg::onWake(%this)
	{
		if(!$ZoomKeys)
		{
			$RemapName[$RemapCount]="ChainZoom Toggle";
			$RemapCmd[$RemapCount]="ZoomChainZoomToggle";
			$RemapCount++;
			$ZoomKeys = 1;
		}
		parent::onWake(%this);
	}
	// Adds zoom-keys to pilot-map
	function clientCmdSetPilotVehicleKeys()
	{
	    passengerKeys.copyBind(moveMap, ZoomChainZoomToggle);
	    parent::clientCmdSetPilotVehicleKeys();
	}

	// Adds zoom-keys to passenger-map
	function clientCmdSetPassengerVehicleKeys()
	{
	    passengerKeys.copyBind(moveMap, ZoomChainZoomToggle);
	    parent::clientCmdSetPassengerVehicleKeys();
	}
function DispatchLaunchMode() {
	parent::DispatchLaunchMode();
	addMessageCallBack('onBomberPilot', bomberpstart);
	addMessageCallBack('onVehicleDismount', bomberpend);
	addMessageCallBack('onVehicleDismount', walking);
	addMessageCallBack('msgShrikePilot', flying);
}
};
activatePackage(Zoom);